package furny.swing.admin.statistics.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Map.Entry;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import furny.ga.logger.DataCache;

/**
 * The Class MinMaxFitnessGenerationChart. The charts are just experimental and
 * not documented yet.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class MinMaxFitnessGenerationChart implements IChartSettings {
  @Override
  public JFreeChart createChart(final long runId) {
    final XYSeriesCollection xyDataset = new XYSeriesCollection();
    XYSeries series = new XYSeries("Fitness(max) over generations");

    for (final Entry<Long, Double> entry : DataCache.getInstance()
        .getMaxFitnessOverGenerations(runId).entrySet()) {
      series.add(entry.getKey(), entry.getValue());
    }

    xyDataset.addSeries(series);

    series = new XYSeries("Fitness(min) over generations");

    for (final Entry<Long, Double> entry : DataCache.getInstance()
        .getMinFitnessOverGenerations(runId).entrySet()) {
      series.add(entry.getKey(), entry.getValue());
    }

    xyDataset.addSeries(series);

    final JFreeChart chart = ChartFactory.createXYLineChart(null, // Title
        "Generation", // X-Axis label
        "Fitness", // Y-Axis label
        xyDataset, // Dataset
        PlotOrientation.VERTICAL, //
        true, // Show legend
        true, // show tooltips
        false); // show urls

    final XYPlot plot = (XYPlot) chart.getPlot();

    final XYDifferenceRenderer renderer = new XYDifferenceRenderer(new Color(
        .5f, .5f, 1f, .5f), Color.RED, false);
    renderer.setBaseStroke(new BasicStroke(3.0f));
    renderer.setSeriesPaint(0, Color.GREEN);
    renderer.setSeriesPaint(1, Color.RED);

    plot.setRenderer(renderer);

    // plot.setRenderer(new XYBlockRenderer());

    // NumberAxis na = (NumberAxis) plot.getDomainAxis();
    // na.setTickUnit(new NumberTickUnit(1d));
    // na.setRangeType(RangeType.POSITIVE);
    //
    // na = (NumberAxis) plot.getRangeAxis();
    // na.setTickUnit(new NumberTickUnit(1d));

    // plot.setRenderer(ChartUtil.getBarRenderer());

    return chart;
  }

  @Override
  public String toString() {
    return "Fitness(min/max) / Generations";
  }
}
